// NetBroadcasterDlg.cpp : implementation file
//

#include "stdafx.h"
#include "NetBroadcaster.h"
#include "NetBroadcasterDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

QRETURN on_no_signal_detected_callback( UINT i, PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CNetBroadcasterDlg * pNetBroadcasterDlg = (CNetBroadcasterDlg *)(pUserData);

	pNetBroadcasterDlg->m_nVideoWidths[ i ] = 0;
	
	pNetBroadcasterDlg->m_nVideoHeights[ i ] = 0;
	
	pNetBroadcasterDlg->m_bVideoIsInterleaveds[ i ] = FALSE;
	
	pNetBroadcasterDlg->m_dVideoFrameRates[ i ] = 0.0;
	
	pNetBroadcasterDlg->m_nAudioChannels[ i ] = 0; 
	
	pNetBroadcasterDlg->m_nAudioBitsPerSamples[ i ] = 0;
	
	pNetBroadcasterDlg->m_nAudioSampleFrequencys[ i ] = 0;

	pNetBroadcasterDlg->SetTimer( 0x00000001 + i, 1, NULL );

	return QCAP_RT_OK;
}

QRETURN on_no_signal_removed_callback( UINT i, PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CNetBroadcasterDlg * pNetBroadcasterDlg = (CNetBroadcasterDlg *)(pUserData);

	pNetBroadcasterDlg->m_nVideoWidths[ i ] = 0;
	
	pNetBroadcasterDlg->m_nVideoHeights[ i ] = 0;
	
	pNetBroadcasterDlg->m_bVideoIsInterleaveds[ i ] = FALSE;
	
	pNetBroadcasterDlg->m_dVideoFrameRates[ i ] = 0.0;
	
	pNetBroadcasterDlg->m_nAudioChannels[ i ] = 0; 
	
	pNetBroadcasterDlg->m_nAudioBitsPerSamples[ i ] = 0;
	
	pNetBroadcasterDlg->m_nAudioSampleFrequencys[ i ] = 0;

	pNetBroadcasterDlg->SetTimer( 0x00000001 + i, 1, NULL );

	return QCAP_RT_OK;
}    

QRETURN on_format_changed_callback( UINT i, PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample, ULONG nAudioSampleFrequency, PVOID pUserData )
{
	CNetBroadcasterDlg * pNetBroadcasterDlg = (CNetBroadcasterDlg *)(pUserData);

	pNetBroadcasterDlg->m_nVideoWidths[ i ] = nVideoWidth;
	
	pNetBroadcasterDlg->m_nVideoHeights[ i ] = nVideoHeight;
	
	pNetBroadcasterDlg->m_bVideoIsInterleaveds[ i ] = bVideoIsInterleaved;
	
	pNetBroadcasterDlg->m_dVideoFrameRates[ i ] = dVideoFrameRate;
	
	pNetBroadcasterDlg->m_nAudioChannels[ i ] = nAudioChannels; 
	
	pNetBroadcasterDlg->m_nAudioBitsPerSamples[ i ] = nAudioBitsPerSample;
	
	pNetBroadcasterDlg->m_nAudioSampleFrequencys[ i ] = nAudioSampleFrequency;

	pNetBroadcasterDlg->SetTimer( 0x00000001 + i, 1, NULL );

	CHAR psz[ MAX_PATH ];

	if( i == 0 ) {

		if( bVideoIsInterleaved == TRUE ) {

			sprintf( psz, "INFO: %dx%dI@%2.3fFPS, %dx%dBITSx%dHZ", nVideoWidth, nVideoHeight * 1, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample, nAudioSampleFrequency );

			pNetBroadcasterDlg->m_statFormatL.SetWindowText( psz );
		}
		else {

			sprintf( psz, "INFO: %dx%dP@%2.3fFPS, %dx%dBITSx%dHZ", nVideoWidth, nVideoHeight * 1, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample, nAudioSampleFrequency );

			pNetBroadcasterDlg->m_statFormatL.SetWindowText( psz );
		}
	}
	if( i == 1 ) {

		if( bVideoIsInterleaved == TRUE ) {

			sprintf( psz, "INFO: %dx%dI@%2.3fFPS, %dx%dBITSx%dHZ", nVideoWidth, nVideoHeight * 1, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample, nAudioSampleFrequency );

			pNetBroadcasterDlg->m_statFormatR.SetWindowText( psz );
		}
		else {

			sprintf( psz, "INFO: %dx%dP@%2.3fFPS, %dx%dBITSx%dHZ", nVideoWidth, nVideoHeight * 1, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample, nAudioSampleFrequency );

			pNetBroadcasterDlg->m_statFormatR.SetWindowText( psz );
		}
	}
	return QCAP_RT_OK;
}

QRETURN on_video_preview_callback( UINT i, PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	CNetBroadcasterDlg * pNetBroadcasterDlg = (CNetBroadcasterDlg *)(pUserData);
	
	if( pFrameBuffer == NULL ) { return QCAP_RT_OK; }

	if( nFrameBufferLen == NULL ) { return QCAP_RT_OK; }

	EnterCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSection );

	if( pNetBroadcasterDlg->m_nNetworkServerState > 0x00000000 ) {

//		// STEREO BUFFER DEMO
//		//
//		{	if( i == 0 ) { QCAP_SET_VIDEO_3D_BROADCAST_SERVER_STEREO_UNCOMPRESSION_BUFFER( pNetBroadcasterDlg->m_hNetworkServer, 0, QCAP_COLORSPACE_TYEP_YUY2, pNetBroadcasterDlg->m_nVideoWidths[ i ], pNetBroadcasterDlg->m_nVideoHeights[ i ], pFrameBuffer, nFrameBufferLen, QCAP_3D_STEREO_BUFFER_SIDE_BY_SIDE ); }
	
//			if( i == 0 ) { QCAP_SET_VIDEO_3D_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pNetBroadcasterDlg->m_hNetworkServer, 0 ); }
//		}

		// L&R BUFFER DEMO
		//
		{	if( i == 0 ) { QCAP_SET_VIDEO_3D_BROADCAST_SERVER_L_UNCOMPRESSION_BUFFER( pNetBroadcasterDlg->m_hNetworkServer, 0, QCAP_COLORSPACE_TYEP_YUY2, pNetBroadcasterDlg->m_nVideoWidths[ i ], pNetBroadcasterDlg->m_nVideoHeights[ i ], pFrameBuffer, nFrameBufferLen ); }
		
			if( i == 1 ) { QCAP_SET_VIDEO_3D_BROADCAST_SERVER_R_UNCOMPRESSION_BUFFER( pNetBroadcasterDlg->m_hNetworkServer, 0, QCAP_COLORSPACE_TYEP_YUY2, pNetBroadcasterDlg->m_nVideoWidths[ i ], pNetBroadcasterDlg->m_nVideoHeights[ i ], pFrameBuffer, nFrameBufferLen ); }

			if( i == 0 ) { QCAP_SET_VIDEO_3D_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pNetBroadcasterDlg->m_hNetworkServer, 0 ); }
		}
	}
	LeaveCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSection );

    return QCAP_RT_OK;
}

// PREVIEW AUDIO CALLBACK FUNCTION
//
QRETURN on_audio_preview_callback( UINT i, PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	CNetBroadcasterDlg * pNetBroadcasterDlg = (CNetBroadcasterDlg *)(pUserData);

	if( pFrameBuffer == NULL ) { return QCAP_RT_OK; }

	if( nFrameBufferLen == NULL ) { return QCAP_RT_OK; }

	EnterCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSection );

	if( pNetBroadcasterDlg->m_nNetworkServerState > 0x00000000 ) {

		if( i == 0 ) { 
			
			QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pNetBroadcasterDlg->m_hNetworkServer, 0, pFrameBuffer, nFrameBufferLen );
		}
	}
	LeaveCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSection );

    return QCAP_RT_OK;
}

QRETURN on_no_signal_detected_callback_l( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData ) { return on_no_signal_detected_callback( 0, pDevice, nVideoInput, nAudioInput, pUserData ); }

QRETURN on_no_signal_detected_callback_r( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData ) { return on_no_signal_detected_callback( 1, pDevice, nVideoInput, nAudioInput, pUserData ); }

QRETURN on_no_signal_removed_callback_l( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData ) { return on_no_signal_removed_callback( 0, pDevice, nVideoInput, nAudioInput, pUserData ); }

QRETURN on_no_signal_removed_callback_r( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData ) { return on_no_signal_removed_callback( 1, pDevice, nVideoInput, nAudioInput, pUserData ); }

QRETURN on_format_changed_callback_l( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample, ULONG nAudioSampleFrequency, PVOID pUserData ) { return on_format_changed_callback( 0, pDevice, nVideoInput, nAudioInput, nVideoWidth, nVideoHeight, bVideoIsInterleaved, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample, nAudioSampleFrequency, pUserData ); }

QRETURN on_format_changed_callback_r( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample, ULONG nAudioSampleFrequency, PVOID pUserData ) { return on_format_changed_callback( 1, pDevice, nVideoInput, nAudioInput, nVideoWidth, nVideoHeight, bVideoIsInterleaved, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample, nAudioSampleFrequency, pUserData ); }

QRETURN on_video_preview_callback_l( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_video_preview_callback( 0, pDevice, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }

QRETURN on_video_preview_callback_r( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_video_preview_callback( 1, pDevice, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }

QRETURN on_audio_preview_callback_l( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_audio_preview_callback( 0, pDevice, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }

QRETURN on_audio_preview_callback_r( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_audio_preview_callback( 1, pDevice, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }

extern CNetBroadcasterApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNetBroadcasterDlg dialog

CNetBroadcasterDlg::CNetBroadcasterDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNetBroadcasterDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CNetBroadcasterDlg)
	m_nPort_RTSPOverHTTP = 0;
	m_nPort_RTSP = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CNetBroadcasterDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNetBroadcasterDlg)
	DDX_Control(pDX, IDC_STATIC_FORMAT_R, m_statFormatR);
	DDX_Control(pDX, IDC_STATIC_FORMAT_L, m_statFormatL);
	DDX_Control(pDX, IDC_STATIC_DISPLAY_WINDOW_R, m_statDisplayWindowR);
	DDX_Control(pDX, IDC_STATIC_DISPLAY_WINDOW_L, m_statDisplayWindowL);
	DDX_Text(pDX, IDC_EDIT_HTTP, m_nPort_RTSPOverHTTP);
	DDV_MinMaxDWord(pDX, m_nPort_RTSPOverHTTP, 0, 65535);
	DDX_Text(pDX, IDC_EDIT_RTSP, m_nPort_RTSP);
	DDV_MinMaxDWord(pDX, m_nPort_RTSP, 0, 65535);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CNetBroadcasterDlg, CDialog)
	//{{AFX_MSG_MAP(CNetBroadcasterDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON_START, OnButtonStart)
	ON_BN_CLICKED(IDC_BUTTON_STOP, OnButtonStop)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNetBroadcasterDlg message handlers

BOOL CNetBroadcasterDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	// INITIALIZE COM LIBRARY
	//
	HRESULT hr = CoInitialize( NULL );

	// INITIALIZE MEMBER VARIABLES
	//
	InitializeCriticalSection( &m_hNetworkServerAccessCriticalSection );

	m_pDevices[ 0 ] = NULL;

	m_pDevices[ 1 ] = NULL;

	m_hNetworkServer = NULL;

	m_nNetworkServerState = 0x00000000;

	m_nVideoWidths[ 0 ] = 0;
	
	m_nVideoHeights[ 0 ] = 0;
	
	m_bVideoIsInterleaveds[ 0 ] = FALSE;
	
	m_dVideoFrameRates[ 0 ] = 0.0;
	
	m_nAudioChannels[ 0 ] = 0; 
	
	m_nAudioBitsPerSamples[ 0 ] = 0;
	
	m_nAudioSampleFrequencys[ 0 ] = 0;

	m_nVideoWidths[ 1 ] = 0;
	
	m_nVideoHeights[ 1 ] = 0;
	
	m_bVideoIsInterleaveds[ 1 ] = FALSE;
	
	m_dVideoFrameRates[ 1 ] = 0.0;
	
	m_nAudioChannels[ 1 ] = 0; 
	
	m_nAudioBitsPerSamples[ 1 ] = 0;
	
	m_nAudioSampleFrequencys[ 1 ] = 0;

	m_nPort_RTSP = theApp.GetProfileInt( "DEFAULT", "PORT.RTSP", 554 );

	m_nPort_RTSPOverHTTP = theApp.GetProfileInt( "DEFAULT", "PORT.HTTP", 8080 );

	GetDlgItem( IDC_BUTTON_START )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( FALSE );

	UpdateData( FALSE );

	// INITIALIZE DEVICE RESOURCE
	//
	QCAP_CREATE( "SA7160 PCI", 0, m_statDisplayWindowL.m_hWnd, &m_pDevices[ 0 ], TRUE );

	QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_pDevices[ 0 ], on_format_changed_callback_l, this );

	QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_pDevices[ 0 ], on_no_signal_detected_callback_l, this );

	QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_pDevices[ 0 ], on_no_signal_removed_callback_l, this );

    QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_pDevices[ 0 ], on_video_preview_callback_l, this );

    QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_pDevices[ 0 ], on_audio_preview_callback_l, this );

	QCAP_SET_VIDEO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_AUTO );

	QCAP_SET_AUDIO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_EMBEDDED_AUDIO );

	QCAP_SET_AUDIO_VOLUME( m_pDevices[ 0 ], 0 );

	QCAP_CREATE( "SA7160 PCI", 1, m_statDisplayWindowR.m_hWnd, &m_pDevices[ 1 ], TRUE );

	QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_pDevices[ 1 ], on_format_changed_callback_r, this );

	QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_pDevices[ 1 ], on_no_signal_detected_callback_r, this );

	QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_pDevices[ 1 ], on_no_signal_removed_callback_r, this );

    QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_pDevices[ 1 ], on_video_preview_callback_r, this );

    QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_pDevices[ 1 ], on_audio_preview_callback_r, this );

	QCAP_SET_VIDEO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_AUTO );

	QCAP_SET_AUDIO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_EMBEDDED_AUDIO );

	QCAP_SET_AUDIO_VOLUME( m_pDevices[ 1 ], 0 );

	QCAP_RUN( m_pDevices[ 0 ] );

	QCAP_RUN( m_pDevices[ 1 ] );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CNetBroadcasterDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	
	// UNINITIALIZE DEVICE RESOURCE
	//
	OnButtonStop();

	if( m_pDevices[ 0 ] ) {

		QCAP_STOP( m_pDevices[ 0 ] );

		QCAP_DESTROY( m_pDevices[ 0 ] );

		m_pDevices[ 0 ] = NULL;
	}
	if( m_pDevices[ 1 ] ) {

		QCAP_STOP( m_pDevices[ 1 ] );

		QCAP_DESTROY( m_pDevices[ 1 ] );

		m_pDevices[ 1 ] = NULL;
	}

	// UNINITIALIZE MEMBER VARIABLES
	//
	UpdateData( TRUE );

	theApp.WriteProfileInt( "DEFAULT", "PORT.RTSP", m_nPort_RTSP );

	theApp.WriteProfileInt( "DEFAULT", "PORT.HTTP", m_nPort_RTSPOverHTTP );

	DeleteCriticalSection( &m_hNetworkServerAccessCriticalSection );

	// UNINITIALIZE COM LIBRARY
	// 
	CoUninitialize();
}

void CNetBroadcasterDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CNetBroadcasterDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CNetBroadcasterDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CNetBroadcasterDlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

void CNetBroadcasterDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CNetBroadcasterDlg::OnButtonStart() 
{
	// TODO: Add your control notification handler code here
	
	UpdateData( TRUE );

	OnButtonStop();

	if( m_nVideoWidths[ 0 ] == 0 ) { return ; }

	if( m_nVideoHeights[ 0 ] == 0 ) { return ; }

	if( m_nVideoWidths[ 1 ] == 0 ) { return ; }

	if( m_nVideoHeights[ 1 ] == 0 ) { return ; }

	ULONG cx = m_nVideoWidths[ 0 ];

	ULONG cy = m_nVideoHeights[ 0 ];

	double fps = m_dVideoFrameRates[ 0 ];

	if( m_bVideoIsInterleaveds[ 0 ] ) {

		fps /= 2;
	}
	QCAP_CREATE_BROADCAST_RTSP_SERVER( 0, 1 /*1 CHANNELS*/, &m_hNetworkServer, "root", "root", m_nPort_RTSP, m_nPort_RTSPOverHTTP );

	QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264_3D, QCAP_COLORSPACE_TYEP_YUY2, cx, cy, fps, QCAP_RECORD_MODE_CBR, 8000, 8000000, (int)(fps + 0.5), 0, 0, NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_FULL );

	QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC_ADTS, m_nAudioChannels[ 0 ], m_nAudioBitsPerSamples[ 0 ], m_nAudioSampleFrequencys[ 0 ] );

	QCAP_START_BROADCAST_SERVER( m_hNetworkServer );

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSection );

	m_nNetworkServerState = 0x00000001;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection );

	GetDlgItem( IDC_BUTTON_START )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( TRUE );
}

void CNetBroadcasterDlg::OnButtonStop() 
{
	// TODO: Add your control notification handler code here

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSection );

	m_nNetworkServerState = 0x00000000;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection );

	if ( m_hNetworkServer != NULL ) {

		QCAP_STOP_BROADCAST_SERVER( m_hNetworkServer );

		QCAP_DESTROY_BROADCAST_SERVER( m_hNetworkServer );

		m_hNetworkServer = NULL;
	}
	GetDlgItem( IDC_BUTTON_START )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( FALSE );
}

void CNetBroadcasterDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	if( nIDEvent == 0x00000001 ) {

		KillTimer( 0x00000001 );

		if( m_nVideoWidths[ 0 ] == 0 || 
			
			m_nVideoHeights[ 0 ] == 0 ) {

			m_statFormatL.SetWindowText( _T("INFO: ...") );

			OnButtonStop();
		}
		else {

			CHAR psz[ MAX_PATH ];

			sprintf( psz, "INFO: %d X %d%c @ %2.3fFPS, %dCH x %dBITS x %dHZ", m_nVideoWidths[ 0 ], m_nVideoHeights[ 0 ], m_bVideoIsInterleaveds[ 0 ] ? 'I' : 'P', m_dVideoFrameRates[ 0 ], m_nAudioChannels[ 0 ], m_nAudioBitsPerSamples[ 0 ], m_nAudioSampleFrequencys[ 0 ] );

			m_statFormatL.SetWindowText( psz );
		}
		UpdateData( FALSE );
	}	
	if( nIDEvent == 0x00000002 ) {

		KillTimer( 0x00000002 );

		if( m_nVideoWidths[ 1 ] == 0 || 
			
			m_nVideoHeights[ 1 ] == 0 ) {

			m_statFormatR.SetWindowText( _T("INFO: ...") );

			OnButtonStop();
		}
		else {

			CHAR psz[ MAX_PATH ];

			sprintf( psz, "INFO: %d X %d%c @ %2.3fFPS, %dCH x %dBITS x %dHZ", m_nVideoWidths[ 1 ], m_nVideoHeights[ 1 ], m_bVideoIsInterleaveds[ 1 ] ? 'I' : 'P', m_dVideoFrameRates[ 1 ], m_nAudioChannels[ 1 ], m_nAudioBitsPerSamples[ 1 ], m_nAudioSampleFrequencys[ 1 ] );

			m_statFormatR.SetWindowText( psz );
		}
		UpdateData( FALSE );
	}		
	CDialog::OnTimer(nIDEvent);
}